/******************************************************************************
* File:    main_cfg.h
* 
* Purpose: Control implementation of C-API, flash security, and clock source.
* Author:  Quinten Brooks, Freescale Semiconductor MCD IC Design - Phoenix
* Email:   quinten.brooks@freescale.com
* Date:    2007.08.01
******************************************************************************/


#ifndef __MAIN_CFG_H
#define __MAIN_CFG_H   1

///////////////////////////////////////////////////////////////////////////////
// The following macros control the implementation methods for the C API.
//
// Note: Disabling C-API will cause compiler errors.  The "MCD_C_API" macro
//       should NEVER be set to "_USE_NONE".  The "_NOTIFY_FAIL" macro should
//       NEVER be set to "0".
///////////////////////////////////////////////////////////////////////////////
#define _USE_NONE       0           // Implementation method (0=none)
#define _USE_MACRO      1           // Implementation method (1=macro)
#define _USE_FUNC       2           // Implementation method (2=function)
#define _NOTIFY_PASS    1           // Pass notification control (0=off, 1=on)
#define _NOTIFY_FAIL    1           // Fail notification control (0=off, 1=on)
#define MCD_TB_NOTIFY   _USE_MACRO  // Testbench Notification
#define MCD_PF_NOTIFY   _USE_MACRO  // Pass/Fail Notification
#define MCD_TB_COM      _USE_MACRO  // Testbench Communication
#define MCD_C_API       _USE_MACRO  // C-API 


///////////////////////////////////////////////////////////////////////////////
// The following macros specify values used in the flash configuration block.
//
// Note: To enable Flash Security the following values must be used in the
//       configuration block:
//
//       FLASH_CONFIG_0 = 0xE70A
//       FLASH_CONFIG_1 = 0xC000
///////////////////////////////////////////////////////////////////////////////
#define FLASH_CONFIG_BASE       0x1FF7  // Absolute Address for "flash_config"
#define FLASH_CONFIG_0          0x0000  // Security Value Low (SECL_VAL)
#define FLASH_CONFIG_1          0x0000  // Security Value High (SECH_VAL)
#define FLASH_CONFIG_2          0xFFFF  // Reserved #1
#define FLASH_CONFIG_3          0x0000  // Protection (PROT)
#define FLASH_CONFIG_4          0xFFFF  // Reserved #2
#define FLASH_CONFIG_5          0x0001  // Backdoor Key #1
#define FLASH_CONFIG_6          0x0002  // Backdoor Key #2
#define FLASH_CONFIG_7          0x0003  // Backdoor Key #3
#define FLASH_CONFIG_8          0x0004  // Backdoor Key #4


///////////////////////////////////////////////////////////////////////////////
// The following macros specify which clock to use
//
// Note: Uncomment the appropriate macro for your simulation.  Only one macro
//       can be used at a time.
///////////////////////////////////////////////////////////////////////////////
//#define EXT_CLK_CLKIN         // Use External Clock (CLKIN pin)
//#define EXT_CLK_XTAL          // Use External Clock (XTAL pin)
#define ROSC                    // Use Internal Clock (Relaxation Oscillator)


///////////////////////////////////////////////////////////////////////////////
// The following macro controls Fast ISR definition
//
// Note: Uncomment the macro to compile for fast interrupts.
///////////////////////////////////////////////////////////////////////////////
//#define FAST_ISR


#endif __MAIN_CFG_H

/* End of "main_cfg.h" */
